/* Initialization routine for debugging macros */
/*  Call dbg_init() prior to using DBGPRT* functions */
/*  Uses NFSDEBUG and DEBUGFILE environment variables */
/*   Rich Braun @ Kronos, Inc.  Waltham, MA */
/*   31 Jan 91 */

#include <time.h>
#include "debug.h"

struct _dbgflags __dbgflags__ = {0};
FILE   *__dbgfp__;

void dbg_init ()
{
char *dbglist, *dbgfile, *getenv();
int  setflag;
time_t now;

    /* The code below looks at the NFSDEBUG environment
     * variable for a list of selected debugging options
     * separated by commas (or colons or semicolons).  Macros
     * scattered through the rest of the code are then enabled
     * to output debugging statements depending on the option
     * flags.
     */
    __dbgfp__ = stderr;
    if ((dbglist = getenv ("NFSDEBUG")) != (char *)NULL) {
	(void) strtolower (dbglist);
	while (*dbglist) {
	    if (dbglist[0] == '-') {
		setflag = 0;
		dbglist++;
	    } else
	        setflag = 1;
	    if (!strncmp (dbglist, "all", 3)) {
	        __dbgflags__.rpctrace = 1;
	        __dbgflags__.mountd   = 1;
		__dbgflags__.nfserr   = 1;
	        __dbgflags__.nfsdebug = 1;
	        __dbgflags__.nfsdisp  = 1;
	        __dbgflags__.nfslookup= 1;
	        __dbgflags__.nfsread  = 1;
	        __dbgflags__.nfswrite = 1;
		__dbgflags__.nfstime  = 1;
		__dbgflags__.inode    = 1;
	    }
	    else if (!strncmp (dbglist, "rpctrace", 8))
	        __dbgflags__.rpctrace = setflag;
	    else if (!strncmp (dbglist, "mountd", 6))
	        __dbgflags__.mountd = setflag;
	    else if (!strncmp (dbglist, "nfserr", 6))
	        __dbgflags__.nfserr = setflag;
	    else if (!strncmp (dbglist, "nfsdebug", 8))
	        __dbgflags__.nfsdebug = setflag;
	    else if (!strncmp (dbglist, "nfsdisp", 7))
	        __dbgflags__.nfsdisp = setflag;
	    else if (!strncmp (dbglist, "nfslookup", 9))
	        __dbgflags__.nfslookup = setflag;
	    else if (!strncmp (dbglist, "nfsread", 7))
	        __dbgflags__.nfsread = setflag;
	    else if (!strncmp (dbglist, "nfswrite", 8))
	        __dbgflags__.nfswrite = setflag;
	    else if (!strncmp (dbglist, "nfstime", 7))
	        __dbgflags__.nfstime = setflag;
	    else if (!strncmp (dbglist, "inode", 5))
	        __dbgflags__.inode = setflag;
	    else
	      fprintf (stderr, "DBG-warning:  unable to parse NFSDEBUG='%s'\n",
		       dbglist);
	    dbglist += strcspn (dbglist, ",:;");
	    if (*dbglist) dbglist++;
	}
	if ((dbgfile = getenv ("DEBUGFILE")) != (char *)NULL) {
	    fprintf (stderr, "DBG-debugging output logged to %s\n", dbgfile);
	    if ((__dbgfp__ = fopen (dbgfile, "a")) == (FILE *) NULL) {
		fprintf (stderr, "DBG: warning, can't open output file\n",
			 dbgfile);
	    }
	    prflags (stderr);
	}
	time (&now);
	fprintf (__dbgfp__, "\n### Initiating debugging %s", 
		 ctime (&now));
	prflags (__dbgfp__);
    }
}

/* Routine to print debugging flags */

static prflags (fp)
FILE *fp;
{
	(void) fprintf (fp,"DBG-debugging options set: ");
	if (__dbgflags__.rpctrace) (void) fprintf (fp, "rpctrace ");
	if (__dbgflags__.mountd)   (void) fprintf (fp, "mountd ");
	if (__dbgflags__.nfserr)   (void) fprintf (fp, "nfserr ");
	if (__dbgflags__.nfsdebug) (void) fprintf (fp, "nfsdebug ");
	if (__dbgflags__.nfsdisp)  (void) fprintf (fp, "nfsdisp ");
	if (__dbgflags__.nfslookup)(void) fprintf (fp, "nfslookup ");
	if (__dbgflags__.nfsread)  (void) fprintf (fp, "nfsread ");
	if (__dbgflags__.nfswrite) (void) fprintf (fp, "nfswrite ");
	if (__dbgflags__.nfstime)  (void) fprintf (fp, "nfstime ");
	if (__dbgflags__.inode)    (void) fprintf (fp, "inode ");
	(void) fprintf (fp, "\n");
}
